/* ==============================================================================
   SQL Data Manipulation Language (DML)
-------------------------------------------------------------------------------
   This guide covers the essential DML commands used for inserting, updating, 
   and deleting data in database tables.

   Table of Contents:
     1. INSERT - Adding Data to Tables
     2. UPDATE - Modifying Existing Data
     3. DELETE - Removing Data from Tables
=================================================================================
*/

/* ============================================================================== 
   INSERT
=============================================================================== */

SELECT * FROM customers



/* #1 Method: Manual INSERT using VALUES */
-- Insert new records into the customers table
INSERT INTO customers (id, first_name, country, score)
VALUES 
    (6, 'Anna', 'USA', NULL),
    (7, 'Sam', NULL, 100),
    (8, 'Janvi', 'India', 1000)


sp_help Customers


-- Incorrect column order 
INSERT INTO customers (country ,id, first_name, score)
VALUES 
    ('USA', 11, 'India', NULL)


-- Incorrect data type in values
INSERT INTO customers (id, first_name, country, score)
VALUES 
	('Max', 12, 'Max', NULL)

--Msg 245, Level 16, State 1, Line 41
--Conversion failed when converting the varchar value 'Max' to data type int.




-- Insert a new record with full column values
INSERT INTO customers (id, first_name, country, score)
VALUES (14, 'Max', 'USA', 368)


-- Insert a new record without specifying column names (not recommended)
INSERT INTO customers
VALUES 
    (15, 'Andreas', 'Germany', NULL)

    
-- Insert a record with only id and first_name (other columns will be NULL or default values)
INSERT INTO customers (id, first_name)
VALUES 
    (16, 'Sahra')

SELECT * FROM persons;


ALTER TABLE PERSONS
ADD COUNTRY VARCHAR(100);

ALTER TABLE PERSONS
DROP COLUMN EMAIL;



SELECT * FROM customers;



/* #2 Method: INSERT DATA USING SELECT - Moving Data From One Table to Another */
-- Copy data from the 'customers' table into 'persons'
INSERT INTO persons (id, person_name, birth_date, phone)
SELECT
    id,
    first_name,
    NULL,
    'Unknown'
FROM customers


/* ============================================================================== 
   UPDATE
=============================================================================== */

SELECT * FROM customers WHERE id = 10



-- Change the score of customer with ID 6 to 0
UPDATE customers
SET score = 0
WHERE id = 6



-- Change the score of customer with ID 10 to 0 and update the country to 'UK'
UPDATE customers
SET score = 0,
    country = 'UK'
WHERE id = 10


-- Update all customers with a NULL score by setting their score to 0
UPDATE customers
SET score = 0
WHERE score IS NULL


-- Verify the update
SELECT *
FROM customers
WHERE score IS NULL

/* ============================================================================== 
   DELETE
=============================================================================== */

-- Select customers with an ID greater than 5 before deleting
SELECT *
FROM customers
WHERE id > 5


-- Delete all customers with an ID greater than 5
DELETE FROM customers
WHERE id > 10

SELECT * FROM persons
;


-- Delete all data from the persons table
DELETE FROM persons


-- Faster method to delete all rows, especially useful for large tables
TRUNCATE TABLE persons
